<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->uuid('id')->primary()->default(DB::raw('(UUID())'));
            $table->string('name_ar');
            $table->string('name_en');
            $table->string('slug');
            $table->text('short_description_ar');
            $table->text('short_description_en');
            $table->longText('long_description_ar');
            $table->longText('long_description_en');
            $table->float('price');
            $table->text('objectives_ar');
            $table->text('objectives_en');
            $table->text('course_highlights_ar');
            $table->text('course_highlights_en');

            $table->string('time');

            $table->integer('age_from');
            $table->integer('age_to');

            $table->string('earn_ar');
            $table->string('earn_en');
            $table->string('prerequisites_ar');
            $table->string('prerequisites_en');

            $table->string('instructor_name_ar');
            $table->string('instructor_name_en');
            $table->string('instructor_position_ar');
            $table->string('instructor_position_en');
            $table->string('instructor_short_description_ar');
            $table->string('instructor_short_description_en');
            $table->string('instructor_long_description_ar');
            $table->string('instructor_long_description_en');

            $table->boolean('is_new')->default(false);
            $table->boolean('is_featured')->default(false);
            $table->boolean('status')->default(true);

            $table->foreignUuid('category_id')->references('id')->on('categories');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
