<?php

namespace App\Enums\Home;

enum HomeTypes: int
{
    case ABOUT_KYDZZO = 1;

    case DOCTOR_SECTION = 2;
    case YOU_TUBE = 3;
    case SLOGAN = 4;
    case COVER = 5;

    public static function getHomeTypes(): array
    {
        return [
            self::SLOGAN->value => 'Slogan',
            self::YOU_TUBE->value => 'Youtube',
            self::ABOUT_KYDZZO->value => 'About Kydzzo',
            self::DOCTOR_SECTION->value => 'Doctor Section',
            self::COVER->value => 'Cover Section',

        ];
    }

    public static function getHomeType($type): string
    {
        return match ($type) {
            self::ABOUT_KYDZZO->value => 'About Kydzzo',
            self::DOCTOR_SECTION->value => 'Doctor Section',
            self::YOU_TUBE->value => 'Youtube',
            self::SLOGAN->value => 'Slogan',
                        self::COVER->value => 'Cover',

            null => ' ',
        };
    }

}
